set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 10: requires first running programs storing the predictions from Table 9 (see readme file)

**1. Within-industry components
use $path_out\Table9_predictions_within, clear	

*Calculate contribution of each industry to weighted mean (the sum of this across industries is the total by country-year)
	foreach var of varlist DE* {
		bysort country year code: gen mean`var'=`var'*weight
	}	
	foreach var of varlist DH* {
		bysort country code year: gen mean`var'=`var'*weight_h
	}	
	foreach var of varlist DYn* DYr* DLS* {
		bysort country code year: gen mean`var'=`var'*weight_VA
	}

	
*Calculate weighted means across countries
	*Summing country weights across industries
	foreach var in weight_c weight_h_c weight_VA_c {
		bysort country year: egen tot`var'=sum(`var')
	}
	*Construct mean industry contribution, weighted across countries
	foreach var of varlist meanDE* {
		bysort code year: egen wt`var'=sum(`var'*totweight_c)
	}
	foreach var of varlist meanDH* {
		bysort code year: egen wt`var'=sum(`var'*totweight_h_c)
	}	
	foreach var of varlist meanDYn* meanDYr* meanDLS* {
		bysort code year: egen wt`var'=sum(`var'*totweight_VA_c)
	}	
	*Drop country dimension	
	duplicates drop code year, force
	drop country weight*_c
	keep code code_hier year decade wtmean* weight*
		renvars wtmean*, predrop(6)
	table year, c(sum weight_VA)
	
*Calculate unweighted means across years
	collapse (mean) D* weight_VA, by(code code_hier)
	
	table code_hier, c(mean DLS_net) /*Table 10, column 1*/
	table code_hier, c(mean DE_own mean DE_sup mean DE_cus mean DE_agg mean DE_net) /*Apx Table 12 (or Apx Table 11B in NBER version)*/


**2. Between-industry components (laborshare only)			
use $path_out\Table9_predictions_betw, clear

	merge m:1 country using $path_in\country_weights
	drop _
	keep country code code_hier DLS_net_ind DLS_net weight_ls
	table code, c(sum weight)
	*Construct weighted average industry contribution across countries
	collapse (mean) DLS_net_ind [w=weight_ls], by(code code_hier)
	sort code_hier

	table code_hier, c(mean DLS_net_ind) /*Table 10, column 2*/
